/*
 * Decompiled with CFR 0.152.
 */
package TCPIP_Discoverer;

import TCPIP_Discoverer.TCPIPAboutBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TcpIpDiscoverTool
extends JFrame {
    public static DatagramSocket socket1;
    public static DatagramSocket socket2;
    public static DatagramSocket socket3;
    public static DatagramSocket socket4;
    public static DatagramPacket packet1;
    public static DatagramPacket packet2;
    public static DatagramPacket packet3;
    public static DatagramPacket packet4;
    public static DefaultTableModel table_model;
    public static Thread recvThread1;
    public static Thread recvThread2;
    public static Thread recvThread3;
    public static Thread recvThread4;
    public static String mchipUrl;
    byte[] messageData = new byte[]{-119, 22, -118, -50, 0, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, -8, 56, 71, -98, 0, 0, -64, -88, 1, 33, -1, -1, -1, -1, -1, -1, 0, 0, -64, -88, 1, -1, -1, -1, -1, -1, 0, 0, 0, 0};
    String messageStr1 = new String("Discovery: Who is out there?\u0000\n");
    long threadSleep = 500L;
    ReentrantLock lock = new ReentrantLock();
    ImageIcon icon = new ImageIcon(this.getClass().getResource("/Resource/mchpIcon.png"));
    String OS = "";
    String interfaceName1 = "";
    String interfaceName2 = "";
    NetworkInterface network1;
    NetworkInterface network2;
    InetAddress hostIP1;
    InetAddress hostIP2;
    String hostMAC1 = "";
    String hostMAC2 = "";
    InetAddress broadcastAddress1;
    InetAddress broadcastAddress2;
    int interface_count = 0;
    Boolean networkChanged1 = false;
    Boolean networkChanged2 = false;
    Boolean doAction = true;
    String debugMsg = "";
    private JTree tree;
    private JScrollPane scrollPane;
    private DatagramSocket socket;
    private DatagramPacket packet;
    private Thread recvThread = null;
    TCPIPAboutBox aboutBox;
    String discvStr = new String("Discovery: Who is out there?\u0000\n");
    String received = " ";
    DefaultMutableTreeNode root;
    DefaultMutableTreeNode harmonyNode;
    DefaultMutableTreeNode mlaNode;
    DefaultTreeModel model;
    short gSegFlag = 0;
    int clickCnt = 0;
    static String[] OUI_Microchip_byte;
    ANNOUNCE_SOCKET_BCAST_TYPE annce_bcast_type;
    private JButton btnDiscover;
    private JButton btnExit;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JLabel labelAbout;

    public TcpIpDiscoverTool() {
        this.initComponents();
        this.changeTableColumnWidth();
        this.aboutBox = new TCPIPAboutBox((Frame)this, true);
        this.setIconImage(this.icon.getImage());
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        String aboutStr = "<html>Date   - Sep 21, 2018<br>";
        String version = "Version - TCPIP Discoverer 2.3";
        this.labelAbout.setText("About");
        this.root = new DefaultMutableTreeNode("Microchip Devices");
        this.model = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.root);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.tree);
        this.udpAction();
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TcpIpDiscoverTool.this.treeMouseClicked(evt);
            }
        });
        this.pack();
    }

    void treeMouseClicked(MouseEvent evt) {
        this.clickCnt += evt.getClickCount();
        if (this.clickCnt == 2) {
            DefaultMutableTreeNode parentNode = null;
            DefaultMutableTreeNode ipNode = null;
            TreePath parentPath = this.tree.getSelectionPath();
            if (parentPath == null) {
                return;
            }
            parentNode = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
            String MacAddress = parentNode.toString();
            if (!MacAddress.startsWith("MAC-Address")) {
                return;
            }
            if (parentNode != null && (ipNode = this.findNode("IP Addresses", parentNode)) != null) {
                DefaultMutableTreeNode ipAddress = (DefaultMutableTreeNode)ipNode.getChildAt(0);
                String ipv4Str = ipAddress.toString();
                mchipUrl = "http://" + ipv4Str;
                try {
                    URL myUrl = new URL(mchipUrl);
                    Desktop.getDesktop().browse(myUrl.toURI());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.clickCnt = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void receiveUDPPacket1() {
        buf = new byte[500];
        for (i = 0; i < buf.length; ++i) {
            buf[i] = 32;
        }
        TcpIpDiscoverTool.packet1 = new DatagramPacket(buf, buf.length);
        try {
            TcpIpDiscoverTool.socket1.receive(TcpIpDiscoverTool.packet1);
        }
        catch (IOException e) {
            optionStr = "<html>Error receiving packet1";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
        while (true) lbl-1000:
        // 5 sources

        {
            for (i = 0; i < buf.length; ++i) {
                buf[i] = 32;
            }
            TcpIpDiscoverTool.packet1 = new DatagramPacket(buf, buf.length);
            try {
                TcpIpDiscoverTool.socket1.receive(TcpIpDiscoverTool.packet1);
            }
            catch (IOException e) {
                optionStr = "<html>Error receiving packet1";
                JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
                this.close_action();
            }
            if (new String(TcpIpDiscoverTool.packet1.getData()).trim().length() == 0 || TcpIpDiscoverTool.packet1.getLength() < 35) ** continue;
            this.lock.lock();
            try {
                this.addDiscoveryEntry(TcpIpDiscoverTool.packet1);
                ** continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void receiveUDPPacket2() {
        buf = new byte[500];
        for (i = 0; i < buf.length; ++i) {
            buf[i] = 32;
        }
        TcpIpDiscoverTool.packet2 = new DatagramPacket(buf, buf.length);
        try {
            TcpIpDiscoverTool.socket2.receive(TcpIpDiscoverTool.packet2);
        }
        catch (IOException e) {
            optionStr = "<html>Error receiving packet2";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
        while (true) lbl-1000:
        // 5 sources

        {
            for (i = 0; i < buf.length; ++i) {
                buf[i] = 32;
            }
            TcpIpDiscoverTool.packet2 = new DatagramPacket(buf, buf.length);
            try {
                TcpIpDiscoverTool.socket2.receive(TcpIpDiscoverTool.packet2);
            }
            catch (IOException e) {
                optionStr = "<html>Error receiving packet2";
                JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
                this.close_action();
            }
            if (TcpIpDiscoverTool.packet2.getLength() < 35) ** continue;
            this.lock.lock();
            try {
                this.addDiscoveryEntry(TcpIpDiscoverTool.packet2);
                ** continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void receiveUDPPacket3() {
        buf = new byte[500];
        for (i = 0; i < buf.length; ++i) {
            buf[i] = 32;
        }
        TcpIpDiscoverTool.packet3 = new DatagramPacket(buf, buf.length);
        try {
            TcpIpDiscoverTool.socket3.receive(TcpIpDiscoverTool.packet3);
        }
        catch (IOException e) {
            optionStr = "<html>Error receiving packet3";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
        while (true) lbl-1000:
        // 5 sources

        {
            for (i = 0; i < buf.length; ++i) {
                buf[i] = 32;
            }
            TcpIpDiscoverTool.packet3 = new DatagramPacket(buf, buf.length);
            try {
                TcpIpDiscoverTool.socket3.receive(TcpIpDiscoverTool.packet3);
            }
            catch (IOException e) {
                optionStr = "<html>Error receiving packet3";
                JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
                this.close_action();
            }
            if (new String(TcpIpDiscoverTool.packet3.getData()).trim().length() == 0 || TcpIpDiscoverTool.packet3.getLength() < 35) ** continue;
            this.lock.lock();
            try {
                this.addDiscoveryEntry(TcpIpDiscoverTool.packet3);
                ** continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void receiveUDPPacket4() {
        buf = new byte[500];
        for (i = 0; i < buf.length; ++i) {
            buf[i] = 32;
        }
        TcpIpDiscoverTool.packet4 = new DatagramPacket(buf, buf.length);
        try {
            TcpIpDiscoverTool.socket4.receive(TcpIpDiscoverTool.packet4);
        }
        catch (IOException e) {
            optionStr = "<html>Error receiving packet4";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
        while (true) lbl-1000:
        // 5 sources

        {
            for (i = 0; i < buf.length; ++i) {
                buf[i] = 32;
            }
            TcpIpDiscoverTool.packet4 = new DatagramPacket(buf, buf.length);
            try {
                TcpIpDiscoverTool.socket4.receive(TcpIpDiscoverTool.packet4);
            }
            catch (IOException e) {
                optionStr = "<html>Error receiving packet4";
                JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
                this.close_action();
            }
            if (TcpIpDiscoverTool.packet4.getLength() < 35) ** continue;
            this.lock.lock();
            try {
                this.addDiscoveryEntry(TcpIpDiscoverTool.packet4);
                ** continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    static void displayInterfaceInformation(NetworkInterface netint) throws SocketException {
        if (netint.isUp() && netint.supportsMulticast() && !netint.isLoopback()) {
            System.out.printf("Display name: %s\n", netint.getDisplayName());
            System.out.printf("Name: %s\n", netint.getName());
            Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
            for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                System.out.printf("InetAddress: %s\n", inetAddress);
            }
            System.out.printf("Up? %s\n", netint.isUp());
            System.out.printf("Loopback? %s\n", netint.isLoopback());
            System.out.printf("PointToPoint? %s\n", netint.isPointToPoint());
            System.out.printf("Supports multicast? %s\n", netint.supportsMulticast());
            System.out.printf("Virtual? %s\n", netint.isVirtual());
            System.out.printf("Hardware address: %s\n", Arrays.toString(netint.getHardwareAddress()));
            System.out.printf("MTU: %s\n", netint.getMTU());
            System.out.printf("\n", new Object[0]);
        }
    }

    public void getNetworkInterfaces() {
        this.interface_count = 0;
        try {
            this.OS = System.getProperty("os.name").toLowerCase();
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                if (netint.getDisplayName().contains("Virtual") || !netint.isUp() || !netint.supportsMulticast() || netint.isLoopback()) continue;
                Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    if (inetAddress.getAddress().length != 4) continue;
                    this.debugMsg = inetAddress.toString();
                    ++this.interface_count;
                    if (this.interface_count == 1) {
                        if (this.network1 == null) {
                            this.network1 = netint;
                        } else if (!this.network1.equals(netint)) {
                            this.networkChanged1 = true;
                            this.network1 = netint;
                        } else {
                            this.networkChanged1 = false;
                        }
                        this.hostIP1 = inetAddress;
                        this.interfaceName1 = this.network1.getName();
                        continue;
                    }
                    if (this.interface_count != 2) continue;
                    if (this.network2 == null) {
                        this.network2 = netint;
                    } else if (!this.network2.equals(netint)) {
                        this.networkChanged2 = true;
                        this.network2 = netint;
                    } else {
                        this.networkChanged2 = false;
                    }
                    this.hostIP2 = inetAddress;
                    this.interfaceName2 = this.network2.getName();
                }
            }
        }
        catch (SocketException e) {
            String optionStr = "<html>Error enumerating network interfaces";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
    }

    public void generatePackets() {
        try {
            byte[] ipAddrs;
            InetAddress i;
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            int mask = 0;
            byte[] result = new byte[4];
            byte[] netmask = new byte[4];
            for (InterfaceAddress addr : this.network1.getInterfaceAddresses()) {
                InetAddress bcastAddr1;
                i = addr.getAddress();
                if (!(i instanceof Inet4Address) || i.isLoopbackAddress()) continue;
                ipAddrs = i.getAddress();
                if (addr.getNetworkPrefixLength() == -1) continue;
                mask = -1 << 32 - addr.getNetworkPrefixLength();
                netmask[0] = (byte)(mask >> 24);
                netmask[1] = (byte)(mask >> 16);
                netmask[2] = (byte)(mask >> 8);
                netmask[3] = (byte)mask;
                result[0] = (byte)(ipAddrs[0] | ~netmask[0]);
                result[1] = (byte)(ipAddrs[1] | ~netmask[1]);
                result[2] = (byte)(ipAddrs[2] | ~netmask[2]);
                result[3] = (byte)(ipAddrs[3] | ~netmask[3]);
                this.broadcastAddress1 = bcastAddr1 = InetAddress.getByAddress(result);
            }
            if (this.interface_count > 1) {
                for (InterfaceAddress addr : this.network2.getInterfaceAddresses()) {
                    InetAddress bcastAddr2;
                    i = addr.getAddress();
                    if (!(i instanceof Inet4Address) || i.isLoopbackAddress()) continue;
                    ipAddrs = i.getAddress();
                    if (addr.getNetworkPrefixLength() == -1) continue;
                    mask = -1 << 32 - addr.getNetworkPrefixLength();
                    netmask[0] = (byte)(mask >> 24);
                    netmask[1] = (byte)(mask >> 16);
                    netmask[2] = (byte)(mask >> 8);
                    netmask[3] = (byte)mask;
                    result[0] = (byte)(ipAddrs[0] | ~netmask[0]);
                    result[1] = (byte)(ipAddrs[1] | ~netmask[1]);
                    result[2] = (byte)(ipAddrs[2] | ~netmask[2]);
                    result[3] = (byte)(ipAddrs[3] | ~netmask[3]);
                    this.broadcastAddress2 = bcastAddr2 = InetAddress.getByAddress(result);
                }
            }
            byte[] array1 = this.messageStr1.getBytes();
            packet1 = new DatagramPacket(array1, this.messageStr1.length(), this.broadcastAddress1, 30303);
            byte[] mac = this.network1.getHardwareAddress();
            this.messageData[120] = mac[0];
            this.messageData[121] = mac[1];
            this.messageData[122] = mac[2];
            this.messageData[123] = mac[3];
            this.messageData[124] = mac[4];
            this.messageData[125] = mac[5];
            StringBuilder sb = new StringBuilder(22);
            for (byte b : mac) {
                if (sb.length() > 0) {
                    sb.append(':');
                }
                sb.append(String.format("%02X", b));
            }
            this.hostMAC1 = sb.toString();
            String blah = this.hostIP1.getHostAddress();
            int[] ipInt = new int[4];
            String[] ipStr = blah.split("\\.");
            ipInt[0] = Integer.parseInt(ipStr[0]);
            ipInt[1] = Integer.parseInt(ipStr[1]);
            ipInt[2] = Integer.parseInt(ipStr[2]);
            ipInt[3] = Integer.parseInt(ipStr[3]);
            this.messageData[128] = (byte)ipInt[0];
            this.messageData[129] = (byte)ipInt[1];
            this.messageData[130] = (byte)ipInt[2];
            this.messageData[131] = (byte)ipInt[3];
            this.messageData[136] = (byte)ipInt[0];
            this.messageData[137] = (byte)ipInt[1];
            this.messageData[137] = (byte)ipInt[2];
            packet2 = new DatagramPacket(this.messageData, this.messageData.length, this.broadcastAddress1, 7778);
            if (this.interface_count > 1) {
                array1 = this.messageStr1.getBytes();
                packet3 = new DatagramPacket(array1, this.messageStr1.length(), this.broadcastAddress2, 30303);
                mac = this.network2.getHardwareAddress();
                this.messageData[120] = mac[0];
                this.messageData[121] = mac[1];
                this.messageData[122] = mac[2];
                this.messageData[123] = mac[3];
                this.messageData[124] = mac[4];
                this.messageData[125] = mac[5];
                sb = new StringBuilder(22);
                for (byte b : mac) {
                    if (sb.length() > 0) {
                        sb.append(':');
                    }
                    sb.append(String.format("%02X", b));
                }
                this.hostMAC2 = sb.toString();
                blah = this.hostIP2.getHostAddress();
                ipInt = new int[4];
                ipStr = blah.split("\\.");
                ipInt[0] = Integer.parseInt(ipStr[0]);
                ipInt[1] = Integer.parseInt(ipStr[1]);
                ipInt[2] = Integer.parseInt(ipStr[2]);
                ipInt[3] = Integer.parseInt(ipStr[3]);
                this.messageData[128] = (byte)ipInt[0];
                this.messageData[129] = (byte)ipInt[1];
                this.messageData[130] = (byte)ipInt[2];
                this.messageData[131] = (byte)ipInt[3];
                this.messageData[136] = (byte)ipInt[0];
                this.messageData[137] = (byte)ipInt[1];
                this.messageData[137] = (byte)ipInt[2];
                packet4 = new DatagramPacket(this.messageData, this.messageData.length, this.broadcastAddress2, 7778);
            }
        }
        catch (IOException e) {
            String optionStr = "<html>Error generating discovery message.";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
    }

    public void udpAction() {
        this.getNetworkInterfaces();
        if (this.interface_count > 0) {
            this.generatePackets();
            try {
                recvThread1 = new Thread(){

                    @Override
                    public void run() {
                        TcpIpDiscoverTool.this.receiveUDPPacket1();
                    }
                };
                recvThread2 = new Thread(){

                    @Override
                    public void run() {
                        TcpIpDiscoverTool.this.receiveUDPPacket2();
                    }
                };
                socket1 = new DatagramSocket(30303);
                socket2 = new DatagramSocket(7778);
                socket1.setBroadcast(true);
                socket2.setBroadcast(true);
                if (this.interface_count > 1) {
                    recvThread3 = new Thread(){

                        @Override
                        public void run() {
                            TcpIpDiscoverTool.this.receiveUDPPacket3();
                        }
                    };
                    recvThread4 = new Thread(){

                        @Override
                        public void run() {
                            TcpIpDiscoverTool.this.receiveUDPPacket4();
                        }
                    };
                    socket3 = new DatagramSocket(30303, this.hostIP2);
                    socket4 = new DatagramSocket(7778, this.hostIP2);
                }
                socket1.send(packet1);
                socket2.send(packet2);
                recvThread1.start();
                recvThread2.start();
                if (this.interface_count > 1) {
                    socket3.send(packet3);
                    socket4.send(packet4);
                    recvThread3.start();
                    recvThread4.start();
                }
            }
            catch (IOException e) {
                String optionStr = "<html>Unable to transmit discovery message. <br> Check network connectivity and ensure that no other instances of this program are running.";
                JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
                this.close_action();
                System.exit(0);
            }
        }
    }

    public void close_action() {
        if (socket1 != null && socket1.isConnected()) {
            socket1.close();
        }
        if (socket2 != null && socket2.isConnected()) {
            socket2.close();
        }
        if (socket3 != null && socket3.isConnected()) {
            socket3.close();
        }
        if (socket4 != null && socket4.isConnected()) {
            socket4.close();
        }
        if (recvThread1 != null && recvThread1.isAlive()) {
            recvThread1 = null;
        }
        if (recvThread2 != null && recvThread2.isAlive()) {
            recvThread2 = null;
        }
        if (recvThread3 != null && recvThread3.isAlive()) {
            recvThread3 = null;
        }
        if (recvThread4 != null && recvThread4.isAlive()) {
            recvThread4 = null;
        }
    }

    public void addnow() {
        Object[] s = new String[]{this.hostIP1.getHostAddress(), this.hostIP1.getHostName(), this.network1.getName(), "", "", Boolean.toString(this.network1.isVirtual()), this.network1.getInterfaceAddresses().toString(), Integer.toString(this.network1.getIndex()), Integer.toString(this.interface_count)};
        table_model.insertRow(0, s);
    }

    public void addDiscoveryEntry(DatagramPacket receivedPacket) {
        String byteToStr;
        byte[] temp;
        byte[] paktBuf = receivedPacket.getData();
        int packetLen = receivedPacket.getLength();
        int dataCnt = 0;
        String ipAddr = receivedPacket.getAddress().getHostAddress();
        String macAddress = "";
        String hostName = "";
        String modelName = "";
        String portNumber = "";
        String version = "";
        String otherInfo = "";
        String SSID = "";
        String wirelessMAC = "";
        int i = 0;
        char[] charArray = ipAddr.toCharArray();
        if (charArray[0] == '2' && charArray[1] == '5' && charArray[2] == '5') {
            return;
        }
        if (paktBuf[0] >= 32 && paktBuf[15] == 13 && paktBuf[16] == 10) {
            temp = new byte[100];
            i = 0;
            while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10 && i < 100) {
                temp[i++] = paktBuf[dataCnt++];
            }
            hostName = byteToStr = new String(temp);
            ++dataCnt;
            ++dataCnt;
            temp = new byte[100];
            for (i = 0; i < 18; ++i) {
                temp[i] = paktBuf[dataCnt] == 45 ? 58 : paktBuf[dataCnt];
                ++dataCnt;
            }
            macAddress = byteToStr = new String(temp);
            ++dataCnt;
            if (packetLen == 36) {
                modelName = "TPDIN-Monitor-WEB";
            } else if (packetLen > 36 && packetLen < 50) {
                temp = new byte[100];
                i = 0;
                while (dataCnt < packetLen) {
                    temp[i] = paktBuf[dataCnt];
                    ++i;
                    ++dataCnt;
                }
                otherInfo = byteToStr = new String(temp);
                otherInfo = "testing";
            } else if (packetLen > 50) {
                temp = new byte[100];
                i = 0;
                while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10 && i < 100) {
                    temp[i++] = paktBuf[dataCnt++];
                }
                modelName = byteToStr = new String(temp);
                ++dataCnt;
                temp = new byte[100];
                i = 0;
                while (paktBuf[dataCnt] != 58 && paktBuf[dataCnt + 1] != 32 && i < 100) {
                    ++dataCnt;
                }
                ++dataCnt;
                ++dataCnt;
                while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10 && i < 100) {
                    temp[i++] = paktBuf[dataCnt++];
                }
                portNumber = byteToStr = new String(temp);
                ++dataCnt;
                temp = new byte[100];
                i = 0;
                while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10 && i < 100) {
                    temp[i++] = paktBuf[dataCnt++];
                }
                version = byteToStr = new String(temp);
                ++dataCnt;
            } else {
                otherInfo = String.valueOf(packetLen);
            }
        } else if (paktBuf[0] == 2) {
            dataCnt = 0;
            while (dataCnt < packetLen) {
                switch (paktBuf[dataCnt]) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        temp = new byte[6];
                        ++dataCnt;
                        for (i = 0; i < 6; ++i) {
                            temp[i] = paktBuf[dataCnt++];
                        }
                        if (temp.length == 0) break;
                        StringBuilder sb = new StringBuilder(22);
                        for (byte b : temp) {
                            if (sb.length() > 0) {
                                sb.append(':');
                            }
                            sb.append(String.format("%02X", b));
                        }
                        macAddress = sb.toString();
                        break;
                    }
                    case 3: {
                        ++dataCnt;
                        temp = new byte[16];
                        i = 0;
                        while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10) {
                            temp[i++] = paktBuf[dataCnt++];
                        }
                        temp[i] = 10;
                        String byteToStr2 = new String(temp);
                        byteToStr2 = byteToStr2.substring(0, i);
                        break;
                    }
                    case 4: {
                        String byteToStr2;
                        ++dataCnt;
                        temp = new byte[16];
                        i = 0;
                        while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10) {
                            temp[i++] = paktBuf[dataCnt++];
                        }
                        hostName = byteToStr2 = new String(temp);
                        break;
                    }
                    case 5: {
                        temp = new byte[4];
                        ++dataCnt;
                        i = 0;
                        while (i < 4) {
                            temp[i++] = paktBuf[dataCnt++];
                        }
                        if (temp.length == 0) break;
                        StringBuilder sb = new StringBuilder(22);
                        for (byte b : temp) {
                            if (sb.length() > 0) {
                                sb.append('.');
                            }
                            sb.append(String.format("%d", (short)(b & 0xFF)));
                        }
                        ipAddr = sb.toString();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (paktBuf[dataCnt] == 13) {
                    ++dataCnt;
                }
                if (paktBuf[dataCnt] == 10) {
                    ++dataCnt;
                }
                if (paktBuf[dataCnt] != 13 || paktBuf[dataCnt + 1] != 10) continue;
                dataCnt += 2;
                temp = new byte[100];
                i = 0;
                while (dataCnt < packetLen) {
                    temp[i++] = paktBuf[dataCnt++];
                    if (i != 100) continue;
                }
                try {
                    String msgBuf = new String(temp, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    String optionStr = "<html>Error Encoding Exception";
                    JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
                }
            }
        } else if (paktBuf[0] == -119) {
            temp = new byte[100];
            i = 0;
            for (dataCnt = 0; dataCnt < 30 && paktBuf[dataCnt] != 34; ++dataCnt) {
            }
            if (dataCnt > 20) {
                return;
            }
            for (i = 0; i < 20 && paktBuf[++dataCnt] != 34; ++i) {
                temp[i] = paktBuf[dataCnt];
            }
            modelName = byteToStr = new String(temp);
            ++dataCnt;
            temp = new byte[100];
            ++dataCnt;
            i = 0;
            while (paktBuf[dataCnt] == 0) {
                ++dataCnt;
            }
            while (paktBuf[dataCnt] != 0) {
                temp[i++] = paktBuf[dataCnt++];
            }
            hostName = byteToStr = new String(temp);
            temp = new byte[100];
            dataCnt = 120;
            for (i = 0; i < 6; ++i) {
                temp[i] = paktBuf[dataCnt];
                ++dataCnt;
            }
            macAddress = String.format("%02X", temp[0]) + ":" + String.format("%02X", temp[1]) + ":" + String.format("%02X", temp[2]) + ":" + String.format("%02X", temp[3]) + ":" + String.format("%02X", temp[4]) + ":" + String.format("%02X", temp[5]);
            if (packetLen > 152) {
                dataCnt = 152;
                temp = new byte[100];
                i = 0;
                while (paktBuf[dataCnt] != 0) {
                    temp[i++] = paktBuf[dataCnt++];
                }
                version = byteToStr = new String(temp);
                int numHig = paktBuf[186] & 0xFF;
                int numLow = paktBuf[187] & 0xFF;
                long number = numHig * 256 + numLow;
                portNumber = number > 0L ? Long.toString(number) : "80";
                dataCnt = 188;
                temp = new byte[100];
                i = 0;
                while (paktBuf[dataCnt] != 0 && paktBuf[dataCnt] != 160) {
                    temp[i++] = paktBuf[dataCnt++];
                }
                SSID = new String(temp);
                dataCnt = 220;
                temp = new byte[6];
                for (i = 0; i < 6; ++i) {
                    temp[i] = paktBuf[dataCnt++];
                }
                StringBuilder sb = new StringBuilder(22);
                for (byte b : temp) {
                    if (sb.length() > 0) {
                        sb.append(':');
                    }
                    sb.append(String.format("%02X", b));
                }
                wirelessMAC = sb.toString();
            }
        } else {
            otherInfo = String.valueOf(packetLen);
        }
        table_model = (DefaultTableModel)this.jTable1.getModel();
        int rowCnt = table_model.getRowCount();
        Object[] s = new String[9];
        if (table_model.getRowCount() == 0) {
            s[0] = this.hostIP1.getHostAddress();
            s[1] = this.hostIP1.getHostName();
            if (this.interfaceName1.contains("wlan")) {
                s[2] = "";
                s[3] = this.hostMAC1;
            } else {
                s[2] = this.hostMAC1;
                s[3] = "";
            }
            s[4] = "";
            s[5] = "";
            s[6] = "";
            s[7] = "";
            s[8] = this.interfaceName1 + " " + this.OS;
            table_model.insertRow(rowCnt, s);
            ++rowCnt;
            if (this.interface_count > 1) {
                s[0] = this.hostIP2.getHostAddress();
                s[1] = this.hostIP2.getHostName();
                if (this.interfaceName2.contains("wlan")) {
                    s[2] = "";
                    s[3] = this.hostMAC2;
                } else {
                    s[2] = this.hostMAC2;
                    s[3] = "";
                }
                s[4] = "";
                s[5] = "";
                s[6] = "";
                s[7] = "";
                s[8] = this.interfaceName2 + " " + this.OS;
                table_model.insertRow(rowCnt, s);
                ++rowCnt;
            }
        }
        s[0] = ipAddr;
        s[1] = hostName;
        s[2] = macAddress;
        s[3] = wirelessMAC;
        s[4] = modelName;
        s[5] = portNumber;
        s[6] = version;
        s[7] = SSID;
        s[8] = otherInfo;
        rowCnt = table_model.getRowCount();
        for (int index = 1; index < rowCnt; ++index) {
            String macAddrs = (String)table_model.getValueAt(index, 2);
            if (macAddrs.isEmpty() || !((String)s[2]).contentEquals(macAddrs)) continue;
            table_model.removeRow(index);
            table_model.insertRow(index, s);
            return;
        }
        table_model.insertRow(rowCnt, s);
        this.jTable1.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Color color1 = new Color(255, 255, 255);
                Color color2 = new Color(240, 240, 255);
                c.setBackground(row % 2 == 0 ? color1 : color2);
                return c;
            }
        });
    }

    public boolean addEntryForMLAAnnoucePacket(DatagramPacket receivedPacket) {
        int i;
        String packetString = new String(receivedPacket.getData());
        String[] packetBuf = packetString.split("\r\n");
        InetAddress ipAddres = receivedPacket.getAddress();
        String ipAddrStr = ipAddres.toString();
        DefaultMutableTreeNode macNode = null;
        DefaultMutableTreeNode ipNode = null;
        DefaultMutableTreeNode messageNode = null;
        String mlaNodeName = "Microchip Legacy Library";
        String macAddress = "MAC-Address - ";
        String hostName = "Hostname - ";
        String ipAddr = "IP Addresses";
        String message = "Message";
        if (ipAddrStr.isEmpty()) {
            return false;
        }
        ipAddrStr = ipAddrStr.replace("/", "");
        if (packetBuf[0].isEmpty()) {
            return false;
        }
        hostName = hostName.concat(packetBuf[0]);
        if (packetBuf[1].isEmpty()) {
            return false;
        }
        for (i = 0; i < OUI_Microchip_byte.length && !packetBuf[1].contains(OUI_Microchip_byte[i]); ++i) {
        }
        if (i > OUI_Microchip_byte.length) {
            return false;
        }
        this.mlaNode = this.findNode(mlaNodeName, this.root);
        if (this.mlaNode == null) {
            this.insertNode(mlaNodeName, this.mlaNode, this.root.getChildCount());
            this.mlaNode = this.findNode(mlaNodeName, this.root);
        }
        if ((macNode = this.findNode(macAddress = macAddress.concat(packetBuf[1]), this.mlaNode)) != null) {
            this.removeNodeFromRoot(macNode);
        }
        this.insertNode(macAddress, this.mlaNode, this.mlaNode.getChildCount());
        macNode = this.findNode(macAddress, this.mlaNode);
        if (this.findNode(hostName, macNode) == null) {
            this.insertNode(hostName, macNode, macNode.getChildCount());
        }
        if ((ipNode = this.findNode(ipAddr, macNode)) == null) {
            this.insertNode(ipAddr, macNode, macNode.getChildCount());
            ipNode = this.findNode(ipAddr, macNode);
        }
        if (this.findNode(ipAddrStr, ipNode) == null) {
            this.insertNode(ipAddrStr, ipNode, ipNode.getChildCount());
        }
        if (packetBuf[2].length() != 0 && packetBuf[2].contains("DHCP")) {
            messageNode = this.findNode(message, macNode);
            if (messageNode == null) {
                this.insertNode(message, macNode, macNode.getChildCount());
                messageNode = this.findNode(message, macNode);
            }
            if (this.findNode(packetBuf[2], messageNode) == null) {
                this.insertNode(packetBuf[2], messageNode, messageNode.getChildCount());
            }
        }
        return true;
    }

    static String ipv6NumericToTextFormat(byte[] src) {
        StringBuffer sb = new StringBuffer(39);
        for (int i = 0; i < 8; ++i) {
            sb.append(Integer.toHexString(src[i << 1] << 8 & 0xFF00 | src[(i << 1) + 1] & 0xFF));
            if (i >= 7) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    private void initComponents() {
        this.btnDiscover = new JButton();
        this.btnExit = new JButton();
        this.labelAbout = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setDefaultCloseOperation(3);
        this.setTitle("Tycon Discovery Tool");
        this.setPreferredSize(new Dimension(1000, 368));
        this.btnDiscover.setText("Discover Devices");
        this.btnDiscover.setCursor(new Cursor(0));
        this.btnDiscover.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpIpDiscoverTool.this.btnDiscoverActionPerformed(evt);
            }
        });
        this.btnExit.setText("Exit");
        this.btnExit.setMaximumSize(new Dimension(115, 23));
        this.btnExit.setMinimumSize(new Dimension(115, 23));
        this.btnExit.setPreferredSize(new Dimension(115, 23));
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpIpDiscoverTool.this.btnExitActionPerformed(evt);
            }
        });
        this.labelAbout.setBackground(new Color(153, 153, 153));
        this.labelAbout.setFont(new Font("Microsoft Sans Serif", 1, 11));
        this.labelAbout.setForeground(new Color(0, 0, 204));
        this.labelAbout.setText("<html>about</html>");
        this.labelAbout.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.labelAbout.setCursor(new Cursor(12));
        this.labelAbout.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TcpIpDiscoverTool.this.labelAboutMouseClicked(evt);
            }
        });
        this.jScrollPane1.setColumnHeader(null);
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setBackground(new Color(240, 240, 240));
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"IP Address", "Hostname", "LAN MAC Address", "WLAN MAC Address", "Model", "Port", "Version", "SSID", "Other"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.setFocusable(false);
        this.jTable1.setRowHeight(20);
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TcpIpDiscoverTool.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        if (this.jTable1.getColumnModel().getColumnCount() > 0) {
            this.jTable1.getColumnModel().getColumn(4).setMinWidth(10);
            this.jTable1.getColumnModel().getColumn(4).setPreferredWidth(100);
            this.jTable1.getColumnModel().getColumn(5).setMinWidth(10);
            this.jTable1.getColumnModel().getColumn(5).setPreferredWidth(50);
            this.jTable1.getColumnModel().getColumn(5).setMaxWidth(200);
            this.jTable1.getColumnModel().getColumn(6).setMinWidth(10);
            this.jTable1.getColumnModel().getColumn(6).setPreferredWidth(100);
        }
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 700, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.btnDiscover, -2, 158, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.labelAbout, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExit, -2, 150, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnDiscover, -2, 28, -2).addComponent(this.btnExit, -2, 28, -2).addComponent(this.labelAbout, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 288, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnDiscoverActionPerformed(ActionEvent evt) {
        try {
            table_model = (DefaultTableModel)this.jTable1.getModel();
            int rowcount = table_model.getRowCount();
            for (int index1 = 0; index1 < rowcount; ++index1) {
                table_model.removeRow(0);
            }
            this.getNetworkInterfaces();
            if (this.networkChanged1.booleanValue() || this.networkChanged2.booleanValue()) {
                this.udpAction();
                this.networkChanged1 = false;
                this.networkChanged2 = false;
            }
            if (this.interface_count > 0) {
                if (!socket1.isBound()) {
                    socket1 = new DatagramSocket(30303, this.hostIP1);
                }
                if (!socket2.isBound()) {
                    socket2 = new DatagramSocket(7778, this.hostIP1);
                }
                if (this.interface_count > 1) {
                    if (!socket3.isBound()) {
                        socket3 = new DatagramSocket(30303, this.hostIP2);
                    }
                    if (!socket4.isBound()) {
                        socket4 = new DatagramSocket(7778, this.hostIP2);
                    }
                }
                this.generatePackets();
                socket1.send(packet1);
                socket2.send(packet2);
                if (this.interface_count > 1) {
                    socket3.send(packet3);
                    socket4.send(packet4);
                }
            }
            this.jTable1.addMouseListener(null);
        }
        catch (IOException soEx) {
            String optionStr = "<html>Unable to transmit discovery message. <br> Check network connectivity and ensure that no other instances of this program are running.";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void labelAboutMouseClicked(MouseEvent evt) {
        this.aboutBox.setVisible(true);
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            Point pt = evt.getPoint();
            int row = this.jTable1.rowAtPoint(pt);
            int col = this.jTable1.columnAtPoint(pt);
            String url = (String)this.jTable1.getValueAt(row, 0);
            String port = (String)this.jTable1.getValueAt(row, 5);
            mchipUrl = port.length() > 0 ? "http://" + url + ":" + port : "http://" + url;
            try {
                URL myUrl = new URL(mchipUrl);
                Desktop.getDesktop().browse(myUrl.toURI());
            }
            catch (Exception ex) {
                String optionStr = "<html>Error generating URL.";
                JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
                this.close_action();
            }
        }
    }

    private DefaultMutableTreeNode findNode(String s, DefaultMutableTreeNode node) {
        Enumeration<TreeNode> e = node.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            if (node.toString().equals(s)) {
                return node;
            }
            if (!node.toString().startsWith(s)) continue;
            return node;
        }
        return null;
    }

    private void insertNode(String s, DefaultMutableTreeNode node, int pos) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(s);
        if (node == null) {
            node = new DefaultMutableTreeNode(s);
            this.model.insertNodeInto(node, this.root, this.root.getChildCount());
        } else {
            this.model.insertNodeInto(child, node, pos);
        }
    }

    private void removeAllNode() {
        boolean i = false;
        while (!this.root.isLeaf()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getFirstChild();
            this.model.removeNodeFromParent(node);
        }
        this.root.removeAllChildren();
        this.model.reload();
    }

    private void removeNodeFromRoot(DefaultMutableTreeNode node) {
        this.model.removeNodeFromParent(node);
    }

    void changeTableColumnWidth() {
        TableColumn column = null;
        final TableCellRenderer tcr = this.jTable1.getTableHeader().getDefaultRenderer();
        this.jTable1.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lbl = (JLabel)tcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                lbl.setBorder(BorderFactory.createCompoundBorder(lbl.getBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
                lbl.setHorizontalAlignment(2);
                return lbl;
            }
        });
        this.jTable1.setAutoResizeMode(4);
        this.jTable1.setDragEnabled(false);
        this.jTable1.setColumnSelectionAllowed(false);
        int colNumber = this.jTable1.getColumnCount();
        for (int i = 0; i < colNumber; ++i) {
            column = this.jTable1.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(100);
                    column.setMaxWidth(120);
                    break;
                }
                case 1: {
                    column.setPreferredWidth(130);
                    column.setMaxWidth(150);
                    break;
                }
                case 2: {
                    column.setPreferredWidth(130);
                    column.setMaxWidth(180);
                    break;
                }
                case 3: {
                    column.setPreferredWidth(100);
                }
            }
            column.setResizable(true);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new TcpIpDiscoverTool().setVisible(true);
            }
        });
    }

    static {
        recvThread1 = null;
        recvThread2 = null;
        recvThread3 = null;
        recvThread4 = null;
        OUI_Microchip_byte = new String[]{"00-04-A3", "00-1E-C0", "D8-80-39", "54-10-EC", "FC-C2-3D", "00-04-25"};
    }

    public static enum ANNOUNCE_SOCKET_BCAST_TYPE {
        ANNOUNCE_UDP_BCAST_NONE,
        ANNOUNCE_UDP_BCAST_NETWORK_LIMITED,
        ANNOUNCE_UDP_BCAST_NETWORK_DIRECTED;

    }
}

