/*
 * Decompiled with CFR 0.152.
 */
package TCPIP_Discoverer;

import TCPIP_Discoverer.TCPIPAboutBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class TcpIpDiscoverTool
extends JFrame {
    public static DatagramSocket socket1;
    public static DatagramSocket socket2;
    public static DatagramPacket packet1;
    public static DatagramPacket packet11;
    public static DatagramPacket packet2;
    public static DatagramPacket packet22;
    public static DefaultTableModel table_model;
    public static Thread recvThread1;
    public static Thread recvThread2;
    public static Thread initThread;
    public static Thread btnThread;
    public static String mchipUrl;
    byte[] messageData1 = new byte[]{-119, 22, -118, -50, 0, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 117, 99, 111, 110, 102, 105, 103, 32, 109, 111, 100, 101, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 99, 111, 110, 102, 105, 103, 32, 102, 105, 114, 109, 119, 97, 114, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 99, 111, 110, 102, 105, 103, 32, 69, 115, 115, 105, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102, 102, 45, 102, 102, 45, 102, 102, 45, 102, 102, 45, 102, 102, 45, 102, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -86, -86, -86, -86, -86, 0, 0, 119, 119, 119, 119, -1, -1, -1, -1, -1, -1, 0, 0, -69, -69, -69, -1, -1, -1, -1, -1, 0, 0, 0, 0};
    byte[] messageData2 = new byte[]{-119, 22, -118, -50, 0, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, -8, 56, 71, -98, 0, 0, -64, -88, 1, 33, -1, -1, -1, -1, -1, -1, 0, 0, -64, -88, 1, -1, -1, -1, -1, -1, 0, 0, 0, 0};
    int[] idle = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    String messageStr1 = new String("Discovery: Who is out there?\u0000\n");
    long threadSleep = 500L;
    ReentrantLock lock = new ReentrantLock();
    ImageIcon icon = new ImageIcon(this.getClass().getResource("/Resource/mchpIcon.png"));
    String OS = "";
    String interfaceName = "";
    NetworkInterface network1;
    InetAddress hostIP1;
    InetAddress hostIP2;
    String hostMAC1 = "";
    InetAddress broadcastAddress1;
    InetAddress broadcastAddress2;
    Boolean networkChanged1 = false;
    Boolean doAction = true;
    String debugMsg = "";
    int interface_count = 0;
    int interface_index = 0;
    private JTree tree;
    private JScrollPane scrollPane;
    private DatagramSocket socket;
    private DatagramPacket packet;
    private Thread recvThread = null;
    TCPIPAboutBox aboutBox;
    String discvStr = new String("Discovery: Who is out there?\u0000\n");
    String received = " ";
    DefaultMutableTreeNode root;
    DefaultMutableTreeNode harmonyNode;
    DefaultMutableTreeNode mlaNode;
    DefaultTreeModel model;
    short gSegFlag = 0;
    int clickCnt = 0;
    static String[] OUI_Microchip_byte;
    ANNOUNCE_SOCKET_BCAST_TYPE annce_bcast_type;
    private JButton btnDiscover;
    private JButton btnExit;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JLabel labelAbout;

    public TcpIpDiscoverTool() {
        this.initComponents();
        this.changeTableColumnWidth();
        this.aboutBox = new TCPIPAboutBox((Frame)this, true);
        this.setIconImage(this.icon.getImage());
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        String aboutStr = "<html>Date   - Sep 10, 2020<br>";
        String version = "Version - TCPIP Discoverer 2.6";
        this.labelAbout.setText("About");
        try {
            socket1 = new DatagramSocket(30303);
            socket1.setBroadcast(true);
            socket2 = new DatagramSocket(7778);
            socket2.setBroadcast(true);
        }
        catch (IOException e) {
            String optionStr = "<html>Unable to transmit discovery message. <br> Check network connectivity and ensure that no other instances of this program are running.";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
            System.exit(0);
        }
        recvThread1 = new Thread(){

            @Override
            public void run() {
                TcpIpDiscoverTool.this.receiveUDPPacket1();
            }
        };
        recvThread2 = new Thread(){

            @Override
            public void run() {
                TcpIpDiscoverTool.this.receiveUDPPacket2();
            }
        };
        recvThread1.start();
        recvThread2.start();
        this.btnDiscover.setText("Working...");
        initThread = new Thread(){

            @Override
            public void run() {
                try {
                    block2: while (true) {
                        TcpIpDiscoverTool.this.doStuff();
                        TcpIpDiscoverTool.this.btnDiscover.setText("Discover Devices");
                        Thread.sleep(10000L);
                        int rowCnt = table_model.getRowCount();
                        int index = 1;
                        while (true) {
                            if (index >= rowCnt) continue block2;
                            int n = index++;
                            TcpIpDiscoverTool.this.idle[n] = TcpIpDiscoverTool.this.idle[n] + 1;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        };
        initThread.start();
    }

    public void clearRows() {
        System.out.println("clearRows");
        table_model = (DefaultTableModel)this.jTable1.getModel();
        int rowcount = table_model.getRowCount();
        for (int index1 = 0; index1 < rowcount; ++index1) {
            table_model.removeRow(0);
        }
    }

    public void doStuff() {
        System.out.println("doStuff");
        this.interface_index = 1;
        table_model = (DefaultTableModel)this.jTable1.getModel();
        int rowcount = table_model.getRowCount();
        this.getNetworkInterfaces();
        if (this.interface_count > 0) {
            this.generatePackets();
            try {
                socket2.send(packet2);
                socket2.send(packet22);
                socket1.send(packet1);
                socket1.send(packet11);
            }
            catch (IOException soEx) {
                this.close_action();
            }
            while (this.interface_index < this.interface_count) {
                ++this.interface_index;
                this.getNetworkInterfaces();
                this.generatePackets();
                try {
                    socket2.send(packet2);
                    socket2.send(packet22);
                    socket1.send(packet1);
                    socket1.send(packet11);
                }
                catch (IOException soEx) {
                    this.close_action();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void receiveUDPPacket1() {
        buf = new byte[500];
        for (i = 0; i < buf.length; ++i) {
            buf[i] = 32;
        }
        TcpIpDiscoverTool.packet1 = new DatagramPacket(buf, buf.length);
        try {
            TcpIpDiscoverTool.socket1.receive(TcpIpDiscoverTool.packet1);
        }
        catch (IOException e) {
            optionStr = "<html>Error receiving packet1";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
        while (true) lbl-1000:
        // 5 sources

        {
            for (i = 0; i < buf.length; ++i) {
                buf[i] = 32;
            }
            TcpIpDiscoverTool.packet1 = new DatagramPacket(buf, buf.length);
            try {
                TcpIpDiscoverTool.socket1.receive(TcpIpDiscoverTool.packet1);
            }
            catch (IOException e) {
                optionStr = "<html>Error receiving packet1";
                JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
                this.close_action();
            }
            if (new String(TcpIpDiscoverTool.packet1.getData()).trim().length() == 0 || TcpIpDiscoverTool.packet1.getLength() < 35) ** continue;
            this.lock.lock();
            try {
                this.addDiscoveryEntry(TcpIpDiscoverTool.packet1);
                ** continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void receiveUDPPacket2() {
        buf = new byte[500];
        for (i = 0; i < buf.length; ++i) {
            buf[i] = 32;
        }
        TcpIpDiscoverTool.packet2 = new DatagramPacket(buf, buf.length);
        try {
            TcpIpDiscoverTool.socket2.receive(TcpIpDiscoverTool.packet2);
        }
        catch (IOException e) {
            optionStr = "<html>Error receiving packet2";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
        while (true) lbl-1000:
        // 5 sources

        {
            for (i = 0; i < buf.length; ++i) {
                buf[i] = 32;
            }
            TcpIpDiscoverTool.packet2 = new DatagramPacket(buf, buf.length);
            try {
                TcpIpDiscoverTool.socket2.receive(TcpIpDiscoverTool.packet2);
            }
            catch (IOException e) {
                optionStr = "<html>Error receiving packet2";
                JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
                this.close_action();
            }
            if (TcpIpDiscoverTool.packet2.getLength() < 35) ** continue;
            this.lock.lock();
            try {
                this.addDiscoveryEntry(TcpIpDiscoverTool.packet2);
                ** continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    public void getNetworkInterfaces() {
        this.interface_count = 0;
        try {
            this.OS = System.getProperty("os.name").toLowerCase();
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                if (netint.getDisplayName().contains("Virtual") || netint.getDisplayName().contains("bridge") || !netint.isUp() || !netint.supportsMulticast() || netint.isLoopback()) continue;
                Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    if (inetAddress.getAddress().length != 4) continue;
                    this.debugMsg = inetAddress.toString();
                    ++this.interface_count;
                    if (this.interface_count != this.interface_index) continue;
                    if (this.network1 == null) {
                        this.network1 = netint;
                    } else if (!this.network1.equals(netint)) {
                        this.networkChanged1 = true;
                        this.network1 = netint;
                    } else {
                        this.networkChanged1 = false;
                    }
                    this.hostIP1 = inetAddress;
                    this.interfaceName = this.network1.getName();
                }
            }
        }
        catch (SocketException e) {
            String optionStr = "<html>Error enumerating network interfaces";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
    }

    public void generatePackets() {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            int mask = 0;
            byte[] result = new byte[4];
            byte[] netmask = new byte[4];
            for (InterfaceAddress addr : this.network1.getInterfaceAddresses()) {
                InetAddress bcastAddr1;
                InetAddress i = addr.getAddress();
                if (!(i instanceof Inet4Address) || i.isLoopbackAddress()) continue;
                byte[] ipAddrs = i.getAddress();
                if (addr.getNetworkPrefixLength() == -1) continue;
                mask = -1 << 32 - addr.getNetworkPrefixLength();
                netmask[0] = (byte)(mask >> 24);
                netmask[1] = (byte)(mask >> 16);
                netmask[2] = (byte)(mask >> 8);
                netmask[3] = (byte)mask;
                result[0] = (byte)(ipAddrs[0] | ~netmask[0]);
                result[1] = (byte)(ipAddrs[1] | ~netmask[1]);
                result[2] = (byte)(ipAddrs[2] | ~netmask[2]);
                result[3] = (byte)(ipAddrs[3] | ~netmask[3]);
                this.broadcastAddress1 = bcastAddr1 = InetAddress.getByAddress(result);
            }
            this.broadcastAddress2 = InetAddress.getByName("255.255.255.255");
            byte[] array1 = this.messageStr1.getBytes();
            packet1 = new DatagramPacket(array1, this.messageStr1.length(), this.broadcastAddress1, 30303);
            packet11 = new DatagramPacket(array1, this.messageStr1.length(), this.broadcastAddress2, 30303);
            byte[] mac1 = this.network1.getHardwareAddress();
            this.messageData1[212] = mac1[0];
            this.messageData1[213] = mac1[1];
            this.messageData1[214] = mac1[2];
            this.messageData1[215] = mac1[3];
            this.messageData1[216] = mac1[4];
            this.messageData1[217] = mac1[5];
            this.messageData2[120] = mac1[0];
            this.messageData2[121] = mac1[1];
            this.messageData2[122] = mac1[2];
            this.messageData2[123] = mac1[3];
            this.messageData2[124] = mac1[4];
            this.messageData2[125] = mac1[5];
            StringBuilder sb1 = new StringBuilder(22);
            for (byte b : mac1) {
                if (sb1.length() > 0) {
                    sb1.append(':');
                }
                sb1.append(String.format("%02X", b));
            }
            this.hostMAC1 = sb1.toString();
            String blah = this.hostIP1.getHostAddress();
            int[] ipInt = new int[4];
            String[] ipStr = blah.split("\\.");
            ipInt[0] = Integer.parseInt(ipStr[0]);
            ipInt[1] = Integer.parseInt(ipStr[1]);
            ipInt[2] = Integer.parseInt(ipStr[2]);
            ipInt[3] = Integer.parseInt(ipStr[3]);
            this.messageData1[220] = (byte)ipInt[0];
            this.messageData1[221] = (byte)ipInt[1];
            this.messageData1[222] = (byte)ipInt[2];
            this.messageData1[223] = (byte)ipInt[3];
            this.messageData1[232] = (byte)ipInt[0];
            this.messageData1[233] = (byte)ipInt[1];
            this.messageData1[234] = (byte)ipInt[2];
            this.messageData2[128] = (byte)ipInt[0];
            this.messageData2[129] = (byte)ipInt[1];
            this.messageData2[130] = (byte)ipInt[2];
            this.messageData2[131] = (byte)ipInt[3];
            this.messageData2[136] = (byte)ipInt[0];
            this.messageData2[137] = (byte)ipInt[1];
            this.messageData2[137] = (byte)ipInt[2];
            packet2 = new DatagramPacket(this.messageData1, this.messageData1.length, this.broadcastAddress1, 7778);
            packet22 = new DatagramPacket(this.messageData2, this.messageData2.length, this.broadcastAddress1, 7778);
        }
        catch (IOException e) {
            String optionStr = "<html>Error generating discovery message.";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
    }

    public void close_action() {
        if (socket1 != null && socket1.isConnected()) {
            socket1.close();
        }
        if (socket2 != null && socket2.isConnected()) {
            socket2.close();
        }
        if (recvThread1 != null && recvThread1.isAlive()) {
            recvThread1 = null;
        }
        if (recvThread2 != null && recvThread2.isAlive()) {
            recvThread2 = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDiscoveryEntry(DatagramPacket receivedPacket) {
        String byteToStr;
        byte[] temp;
        byte[] paktBuf = receivedPacket.getData();
        int packetLen = receivedPacket.getLength();
        int dataCnt = 0;
        String ipAddr = receivedPacket.getAddress().getHostAddress();
        String macAddress = "";
        String hostName = "";
        String modelName = "";
        String portNumber = "";
        String version = "";
        String otherInfo = "";
        String SSID = "";
        String uptime = "";
        String wirelessMAC = "";
        int sum = 0;
        int i = 0;
        char[] charArray = ipAddr.toCharArray();
        if (charArray[0] == '2' && charArray[1] == '5' && charArray[2] == '5') {
            return;
        }
        if (paktBuf[0] >= 32 && paktBuf[15] == 13 && paktBuf[16] == 10) {
            temp = new byte[100];
            i = 0;
            while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10 && i < 100) {
                temp[i++] = paktBuf[dataCnt++];
            }
            hostName = byteToStr = new String(temp);
            ++dataCnt;
            ++dataCnt;
            temp = new byte[100];
            for (i = 0; i < 18; ++i) {
                temp[i] = paktBuf[dataCnt] == 45 ? 58 : paktBuf[dataCnt];
                ++dataCnt;
            }
            macAddress = byteToStr = new String(temp);
            ++dataCnt;
            if (packetLen == 36) {
                modelName = "TPDIN-Monitor-WEB";
            } else if (packetLen > 36 && packetLen < 50) {
                temp = new byte[100];
                i = 0;
                while (dataCnt < packetLen) {
                    temp[i] = paktBuf[dataCnt];
                    ++i;
                    ++dataCnt;
                }
                otherInfo = byteToStr = new String(temp);
            } else if (packetLen > 50) {
                temp = new byte[100];
                i = 0;
                while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10 && i < 100) {
                    temp[i++] = paktBuf[dataCnt++];
                }
                modelName = byteToStr = new String(temp);
                ++dataCnt;
                temp = new byte[100];
                i = 0;
                while (paktBuf[dataCnt] != 58 && paktBuf[dataCnt + 1] != 32 && i < 100) {
                    ++dataCnt;
                }
                ++dataCnt;
                ++dataCnt;
                while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10 && i < 100) {
                    temp[i++] = paktBuf[dataCnt++];
                }
                portNumber = byteToStr = new String(temp);
                ++dataCnt;
                temp = new byte[100];
                i = 0;
                while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10 && i < 100) {
                    temp[i++] = paktBuf[dataCnt++];
                }
                version = byteToStr = new String(temp);
                ++dataCnt;
                temp = new byte[100];
                i = 0;
                while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10 && i < 100) {
                    temp[i++] = paktBuf[dataCnt++];
                }
                int days = 0;
                int hours = 0;
                int minutes = 0;
                minutes += ((temp[1] & 0xFF) - 48) * 10000000;
                minutes += ((temp[2] & 0xFF) - 48) * 1000000;
                minutes += ((temp[3] & 0xFF) - 48) * 100000;
                minutes += ((temp[4] & 0xFF) - 48) * 10000;
                minutes += ((temp[5] & 0xFF) - 48) * 1000;
                minutes += ((temp[6] & 0xFF) - 48) * 100;
                minutes += ((temp[7] & 0xFF) - 48) * 10;
                hours = (minutes += ((temp[8] & 0xFF) - 48) * 1) / 60;
                days = hours / 24;
                uptime = days == 1 ? Integer.toString(days) + " Day " + String.format("%02d", hours) + ":" + String.format("%02d", minutes) : Integer.toString(days) + " Days " + String.format("%02d", hours %= 24) + ":" + String.format("%02d", minutes %= 60);
                ++dataCnt;
            } else {
                otherInfo = String.valueOf(packetLen);
            }
        } else if (paktBuf[0] == 2) {
            dataCnt = 0;
            while (dataCnt < packetLen) {
                switch (paktBuf[dataCnt]) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        temp = new byte[6];
                        ++dataCnt;
                        for (i = 0; i < 6; ++i) {
                            temp[i] = paktBuf[dataCnt++];
                        }
                        if (temp.length == 0) break;
                        StringBuilder sb = new StringBuilder(22);
                        for (int n : temp) {
                            if (sb.length() > 0) {
                                sb.append(':');
                            }
                            sb.append(String.format("%02X", (byte)n));
                        }
                        macAddress = sb.toString();
                        break;
                    }
                    case 3: {
                        ++dataCnt;
                        temp = new byte[16];
                        i = 0;
                        while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10) {
                            temp[i++] = paktBuf[dataCnt++];
                        }
                        temp[i] = 10;
                        String byteToStr2 = new String(temp);
                        byteToStr2 = byteToStr2.substring(0, i);
                        break;
                    }
                    case 4: {
                        String byteToStr2;
                        ++dataCnt;
                        temp = new byte[16];
                        i = 0;
                        while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10) {
                            temp[i++] = paktBuf[dataCnt++];
                        }
                        hostName = byteToStr2 = new String(temp);
                        break;
                    }
                    case 5: {
                        temp = new byte[4];
                        ++dataCnt;
                        i = 0;
                        while (i < 4) {
                            temp[i++] = paktBuf[dataCnt++];
                        }
                        if (temp.length == 0) break;
                        StringBuilder sb = new StringBuilder(22);
                        byte[] hours = temp;
                        int minutes = hours.length;
                        for (int n = 0; n < minutes; ++n) {
                            byte b = hours[n];
                            if (sb.length() > 0) {
                                sb.append('.');
                            }
                            sb.append(String.format("%d", (short)(b & 0xFF)));
                        }
                        ipAddr = sb.toString();
                        break;
                    }
                    case 11: {
                        ++dataCnt;
                        temp = new byte[16];
                        i = 0;
                        while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10) {
                            temp[i++] = paktBuf[dataCnt++];
                        }
                        String byteToStr2 = new String(temp);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (paktBuf[dataCnt] == 13) {
                    ++dataCnt;
                }
                if (paktBuf[dataCnt] == 10) {
                    ++dataCnt;
                }
                if (paktBuf[dataCnt] != 13 || paktBuf[dataCnt + 1] != 10) continue;
                dataCnt += 2;
                temp = new byte[100];
                i = 0;
                while (dataCnt < packetLen) {
                    temp[i++] = paktBuf[dataCnt++];
                    if (i != 100) continue;
                }
                try {
                    String msgBuf = new String(temp, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    String optionStr = "<html>Error Encoding Exception";
                    JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
                }
            }
        } else {
            if (paktBuf[0] != -119) return;
            if (paktBuf[16] == 34) {
                temp = new byte[100];
                i = 0;
                for (dataCnt = 0; dataCnt < 30 && paktBuf[dataCnt] != 34; ++dataCnt) {
                }
                if (dataCnt > 20) {
                    return;
                }
                for (i = 0; i < 20 && paktBuf[++dataCnt] != 34; ++i) {
                    temp[i] = paktBuf[dataCnt];
                }
                modelName = byteToStr = new String(temp);
                ++dataCnt;
                temp = new byte[100];
                ++dataCnt;
                i = 0;
                while (paktBuf[dataCnt] == 0) {
                    ++dataCnt;
                }
                while (paktBuf[dataCnt] != 0) {
                    temp[i++] = paktBuf[dataCnt++];
                }
                hostName = byteToStr = new String(temp);
                temp = new byte[100];
                dataCnt = 120;
                for (i = 0; i < 6; ++i) {
                    temp[i] = paktBuf[dataCnt];
                    ++dataCnt;
                }
                macAddress = String.format("%02X", temp[0]) + ":" + String.format("%02X", temp[1]) + ":" + String.format("%02X", temp[2]) + ":" + String.format("%02X", temp[3]) + ":" + String.format("%02X", temp[4]) + ":" + String.format("%02X", temp[5]);
                if (packetLen > 152) {
                    dataCnt = 152;
                    temp = new byte[100];
                    i = 0;
                    while (paktBuf[dataCnt] != 0) {
                        temp[i++] = paktBuf[dataCnt++];
                    }
                    version = byteToStr = new String(temp);
                    int numHig = paktBuf[186] & 0xFF;
                    int numLow = paktBuf[187] & 0xFF;
                    long number = numHig * 256 + numLow;
                    portNumber = number > 0L ? Long.toString(number) : "80";
                    dataCnt = 188;
                    temp = new byte[100];
                    i = 0;
                    while (paktBuf[dataCnt] != 0 && paktBuf[dataCnt] != 160) {
                        temp[i++] = paktBuf[dataCnt++];
                    }
                    SSID = new String(temp);
                    dataCnt = 220;
                    temp = new byte[6];
                    for (i = 0; i < 6; ++i) {
                        temp[i] = paktBuf[dataCnt++];
                    }
                    StringBuilder sb = new StringBuilder(22);
                    for (byte b : temp) {
                        if (sb.length() > 0) {
                            sb.append(':');
                        }
                        sb.append(String.format("%02X", b));
                    }
                    wirelessMAC = sb.toString();
                }
            } else {
                if (paktBuf[16] != 69) return;
                temp = new byte[100];
                sum = 0;
                for (i = 0; i < 6; ++i) {
                    temp[i] = paktBuf[212 + i];
                    sum += temp[i];
                }
                macAddress = sum == 0 ? "" : String.format("%02X", temp[0]) + ":" + String.format("%02X", temp[1]) + ":" + String.format("%02X", temp[2]) + ":" + String.format("%02X", temp[3]) + ":" + String.format("%02X", temp[4]) + ":" + String.format("%02X", temp[5]);
                sum = 0;
                for (i = 0; i < 17; ++i) {
                    temp[i] = paktBuf[184 + i];
                    sum += temp[i];
                }
                if (sum == 0) {
                    wirelessMAC = "";
                }
                wirelessMAC = "";
                for (i = 0; i < 32; ++i) {
                    temp[i] = paktBuf[16 + i];
                }
                modelName = new String(temp);
                for (i = 0; i < 32; ++i) {
                    temp[i] = paktBuf[48 + i];
                }
                hostName = new String(temp);
                for (i = 0; i < 32; ++i) {
                    temp[i] = paktBuf[112 + i];
                }
                version = new String(temp);
                for (i = 0; i < 32; ++i) {
                    temp[i] = paktBuf[144 + i];
                }
                SSID = new String(temp);
                for (i = 0; i < 32; ++i) {
                    temp[i] = i > 5 ? (byte)0 : paktBuf[176 + i];
                }
                portNumber = new String(temp);
            }
        }
        table_model = (DefaultTableModel)this.jTable1.getModel();
        int rowCnt = table_model.getRowCount();
        Object[] s = new String[10];
        if (table_model.getRowCount() == 0) {
            s[0] = this.hostIP1.getHostAddress();
            s[1] = this.hostIP1.getHostName();
            if (this.interfaceName.contains("wlan")) {
                s[2] = "";
                s[3] = this.hostMAC1;
            } else {
                s[2] = this.hostMAC1;
                s[3] = "";
            }
            s[4] = "";
            s[5] = "";
            s[6] = "";
            s[7] = "";
            s[8] = "";
            s[9] = this.interfaceName + " " + this.OS;
            this.idle[rowCnt] = 0;
            table_model.insertRow(rowCnt, s);
            ++rowCnt;
        }
        s[0] = ipAddr;
        s[1] = hostName;
        s[2] = macAddress;
        s[3] = wirelessMAC;
        s[4] = modelName;
        s[5] = portNumber;
        s[6] = version;
        s[7] = SSID;
        s[8] = uptime;
        s[9] = otherInfo;
        rowCnt = table_model.getRowCount();
        for (int index = 0; index < rowCnt; ++index) {
            String macAddrs = (String)table_model.getValueAt(index, 2);
            String string = (String)table_model.getValueAt(index, 3);
            if (!macAddrs.isEmpty()) {
                if (!((String)s[2]).contentEquals(macAddrs)) continue;
                this.idle[index] = 0;
                table_model.removeRow(index);
                table_model.insertRow(index, s);
                return;
            }
            if (string.isEmpty() || !((String)s[3]).contentEquals(string)) continue;
            this.idle[index] = 0;
            table_model.removeRow(index);
            table_model.insertRow(index, s);
            return;
        }
        this.idle[rowCnt] = 0;
        table_model.insertRow(rowCnt, s);
        this.jTable1.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Color color1 = new Color(255, 255, 255);
                Color color2 = new Color(240, 240, 255);
                Color color3 = new Color(255, 240, 240);
                if (TcpIpDiscoverTool.this.idle[row] > 1) {
                    c.setBackground(color3);
                } else {
                    c.setBackground(row % 2 == 0 ? color1 : color2);
                }
                return c;
            }
        });
    }

    static String ipv6NumericToTextFormat(byte[] src) {
        StringBuffer sb = new StringBuffer(39);
        for (int i = 0; i < 8; ++i) {
            sb.append(Integer.toHexString(src[i << 1] << 8 & 0xFF00 | src[(i << 1) + 1] & 0xFF));
            if (i >= 7) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    private void initComponents() {
        this.btnDiscover = new JButton();
        this.btnExit = new JButton();
        this.labelAbout = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setDefaultCloseOperation(3);
        this.setTitle("Tycon Discovery Tool V2.6");
        this.setPreferredSize(new Dimension(1100, 500));
        this.btnDiscover.setText("Discover Devices");
        this.btnDiscover.setCursor(new Cursor(0));
        this.btnDiscover.setFocusPainted(false);
        this.btnDiscover.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpIpDiscoverTool.this.btnDiscoverActionPerformed(evt);
            }
        });
        this.btnExit.setText("Exit");
        this.btnExit.setMaximumSize(new Dimension(115, 23));
        this.btnExit.setMinimumSize(new Dimension(115, 23));
        this.btnExit.setPreferredSize(new Dimension(115, 23));
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpIpDiscoverTool.this.btnExitActionPerformed(evt);
            }
        });
        this.labelAbout.setBackground(new Color(153, 153, 153));
        this.labelAbout.setFont(new Font("Microsoft Sans Serif", 1, 11));
        this.labelAbout.setForeground(new Color(0, 0, 204));
        this.labelAbout.setText("<html>about</html>");
        this.labelAbout.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.labelAbout.setCursor(new Cursor(12));
        this.labelAbout.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TcpIpDiscoverTool.this.labelAboutMouseClicked(evt);
            }
        });
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setBackground(new Color(240, 240, 240));
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"IP Address", "Hostname", "LAN MAC Address", "WLAN MAC Address", "Model", "Port", "Version", "SSID", "Uptime", "Other"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.setFocusable(false);
        this.jTable1.setRowHeight(20);
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TcpIpDiscoverTool.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        if (this.jTable1.getColumnModel().getColumnCount() > 0) {
            this.jTable1.getColumnModel().getColumn(0).setResizable(false);
            this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(40);
            this.jTable1.getColumnModel().getColumn(1).setResizable(false);
            this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(50);
            this.jTable1.getColumnModel().getColumn(2).setResizable(false);
            this.jTable1.getColumnModel().getColumn(2).setPreferredWidth(100);
            this.jTable1.getColumnModel().getColumn(3).setResizable(false);
            this.jTable1.getColumnModel().getColumn(3).setPreferredWidth(100);
            this.jTable1.getColumnModel().getColumn(4).setResizable(false);
            this.jTable1.getColumnModel().getColumn(4).setPreferredWidth(150);
            this.jTable1.getColumnModel().getColumn(5).setResizable(false);
            this.jTable1.getColumnModel().getColumn(5).setPreferredWidth(40);
            this.jTable1.getColumnModel().getColumn(6).setResizable(false);
            this.jTable1.getColumnModel().getColumn(6).setPreferredWidth(80);
            this.jTable1.getColumnModel().getColumn(7).setResizable(false);
            this.jTable1.getColumnModel().getColumn(7).setPreferredWidth(100);
            this.jTable1.getColumnModel().getColumn(8).setResizable(false);
            this.jTable1.getColumnModel().getColumn(8).setPreferredWidth(70);
            this.jTable1.getColumnModel().getColumn(9).setResizable(false);
            this.jTable1.getColumnModel().getColumn(9).setPreferredWidth(100);
        }
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 1176, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btnDiscover, -2, 158, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.labelAbout, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExit, -2, 150, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnDiscover, -2, 28, -2).addComponent(this.btnExit, -2, 28, -2).addComponent(this.labelAbout, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 533, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void btnDiscoverActionPerformed(ActionEvent evt) {
        this.btnDiscover.setText("Working...");
        btnThread = new Thread(){

            @Override
            public void run() {
                TcpIpDiscoverTool.this.clearRows();
                TcpIpDiscoverTool.this.doStuff();
                TcpIpDiscoverTool.this.btnDiscover.setText("Discover Devices");
            }
        };
        btnThread.start();
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        this.close_action();
        System.exit(0);
    }

    private void labelAboutMouseClicked(MouseEvent evt) {
        this.aboutBox.setVisible(true);
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            Point pt = evt.getPoint();
            int row = this.jTable1.rowAtPoint(pt);
            int col = this.jTable1.columnAtPoint(pt);
            String url = (String)this.jTable1.getValueAt(row, 0);
            String port = (String)this.jTable1.getValueAt(row, 5);
            mchipUrl = port.length() > 0 ? "http://" + url + ":" + port : "http://" + url;
            try {
                URL myUrl = new URL(mchipUrl);
                Desktop.getDesktop().browse(myUrl.toURI());
            }
            catch (Exception ex) {
                String optionStr = "<html>Error generating URL.";
                JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
                this.close_action();
            }
        }
    }

    void changeTableColumnWidth() {
        TableColumn column = null;
        final TableCellRenderer tcr = this.jTable1.getTableHeader().getDefaultRenderer();
        this.jTable1.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lbl = (JLabel)tcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                lbl.setBorder(BorderFactory.createCompoundBorder(lbl.getBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
                lbl.setHorizontalAlignment(2);
                return lbl;
            }
        });
        this.jTable1.setAutoResizeMode(4);
        this.jTable1.setDragEnabled(false);
        this.jTable1.setColumnSelectionAllowed(false);
        int colNumber = this.jTable1.getColumnCount();
        for (int i = 0; i < colNumber; ++i) {
            column = this.jTable1.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(100);
                    column.setMaxWidth(120);
                    break;
                }
                case 1: {
                    column.setPreferredWidth(130);
                    column.setMaxWidth(150);
                    break;
                }
                case 2: {
                    column.setPreferredWidth(130);
                    column.setMaxWidth(180);
                    break;
                }
                case 3: {
                    column.setPreferredWidth(100);
                }
            }
            column.setResizable(true);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new TcpIpDiscoverTool().setVisible(true);
            }
        });
    }

    static {
        recvThread1 = null;
        recvThread2 = null;
        initThread = null;
        btnThread = null;
        OUI_Microchip_byte = new String[]{"00-04-A3", "00-1E-C0", "D8-80-39", "54-10-EC", "FC-C2-3D", "00-04-25"};
    }

    public static enum ANNOUNCE_SOCKET_BCAST_TYPE {
        ANNOUNCE_UDP_BCAST_NONE,
        ANNOUNCE_UDP_BCAST_NETWORK_LIMITED,
        ANNOUNCE_UDP_BCAST_NETWORK_DIRECTED;

    }
}

